// Copyright 2006 Adobe Macromedia Software LLC and its licensors. All rights reserved.
//
// Implements the Active Content extension for Flash and Shockwave.


//----------------------------------------------------------------------------
// generateScript()
//
// Given an <object> or <embed> or <applet> tag, this converts it into a
// <script> tag.
//----------------------------------------------------------------------------
function generateScript(node)
{
  // have the singleton do the work
  return g_flashConverter.generateScript(node);
}

//----------------------------------------------------------------------------
// generateFunctionName()
//
// returns the name of the function that will be inserted into the page
//----------------------------------------------------------------------------
function generateFunctionName()
{
   return g_flashConverter.generateFunctionName();
}

//----------------------------------------------------------------------------
// canConvert()
//
// returns whether this node can be converted
// Given an <object> tag, this returns if the contents of this tag are
// convertible.  The criteria is that only <param> and <embed> tags exist.
// If any other content exists, return FALSE
//----------------------------------------------------------------------------
function canConvert(node)
{
	return g_flashConverter.objectTagHasOnlyParamAndEmbed(node);
}

//----------------------------------------------------------------------------
// supportedTags()
//
// Returns an object with the following properties describing this converter:
//    obj.supportsAppletTag           (bool)
//    obj.supportedObjectTagClassIDs  (array of strings)
//    obj.supportedMimeTypes          (array of strings)
//    obj.supportedEmbedTagExtensions (array of strings)
//----------------------------------------------------------------------------
function supportedTags()
{
  return g_flashConverter;
}

//----------------------------------------------------------------------------
// getIncludeFiles()
//
// Returns an array which is a list of .js files that must be:
//   (a) inserted into the HEAD of the user's HTML document in the form
//       <script src="filename.js"></script>, and
//   (b) added to the user's site.
//----------------------------------------------------------------------------
function getIncludeFiles()
{
  return [ "AC_RunActiveContent.js" ];
}

//----------------------------------------------------------------------------
// Constructor
//----------------------------------------------------------------------------
function FlashActiveContent()
{
  //call the base class constructor
  FlashActiveContent.prototype.constructor();

  // properties used by the caller of supportedTags():
  this.supportedObjectTagClassIDs =
      [ 'clsid:d27cdb6e-ae6d-11cf-96b8-444553540000',   // Flash
        'clsid:166b1bca-3f9c-11cf-8075-444553540000' ]; // Shockwave
  this.supportedMimeTypes = [ 'application/x-shockwave-flash' ];
  this.supportedEmbedTagExtensions = [ ".swf", ".dcr" ];
}

// specify base class
FlashActiveContent.prototype = new ActiveContent();

var g_flashConverter = new FlashActiveContent(); // singleton

//----------------------------------------------------------------------------
// FlashActiveContent_appendAttributes
//
// Given a node, parse its array of attributes.  Appends them to an
// associative array in 'outAttrs'.  Note: This function converts the
// attribute names to lower case.  E.g. if the original node was
//     <tagName attrName='attrVal'>
// then the outAttrs array will contain
//     outAttrs['attrname'] = 'attrVal'
//----------------------------------------------------------------------------
FlashActiveContent.prototype.appendAttributes = function(node, outAttrs)
{
  var attrs = node.attributes;
  var len = attrs.length;
  for (var i=0; i<len; ++i)
  {
    // don't overwrite existing attribute values
    // default behavior is that <object> attributes trump others
    if(!outAttrs[attrs[i].name.toLowerCase()])
    {
      if(! (attrs[i].name.toLowerCase() == "type" && node.tagName.toLowerCase() == "embed") )
      {
        outAttrs[attrs[i].name.toLowerCase()] = attrs[i].value;
      }
    }
  }
}

//----------------------------------------------------------------------------
// FlashActiveContent.processAttributes
//
// Process the list of object/param/embed tags.
//
// Since this ActiveContent converter handles both Flash and Shockwave, we
// examine the attributes in order to determine which one is needed.
//
// We also make necessary changes to the list of attributes, such as
// removing filename extensions and GUIDs.
//----------------------------------------------------------------------------
FlashActiveContent.prototype.processAttributes = function(attrs)
{
  // figure out the two-letter code: Flash (FL) or Shockwave (SW)
  if (attrs.classid && attrs.classid.toLowerCase().indexOf( 'd27cdb6e-ae6d-11cf-96b8-444553540000' ) != -1)
    this.twoLetterCode = 'FL';
  else if (attrs.classid && attrs.classid.toLowerCase().indexOf( '166b1bca-3f9c-11cf-8075-444553540000' ) != -1)
    this.twoLetterCode = 'SW';
  else
  {
    // check for .swf or .dcr extension
    if      (attrs.movie && attrs.movie.search( /\.swf/i )) this.twoLetterCode = 'FL';
    else if (attrs.src   && attrs.src.search  ( /\.swf/i )) this.twoLetterCode = 'FL';
    else if (attrs.movie && attrs.movie.search( /\.dcr/i )) this.twoLetterCode = 'SW';
    else if (attrs.src   && attrs.src.search  ( /\.dcr/i )) this.twoLetterCode = 'SW';
    else this.twoLetterCode = 'FL'; // the default
  }

  // remove extensions
  if (attrs.src)   attrs.src   = attrs.src.replace  ( /(\.swf|\.dcr)/i, "" );
  if (attrs.movie) attrs.movie = attrs.movie.replace( /(\.swf|\.dcr)/i, "" );

  // delete attributes that we don't want copied into the function call
  delete attrs.classid;
  
  ActiveContent.prototype.processAttributes(attrs);
}

FlashActiveContent.prototype.getTwoLetterCode = function()
{
  return this.twoLetterCode;
}
